### Importance of Redundancy

- **Purpose**
    - Designed to eliminate single points of failure in voice and data networks.
    - Physical redundancy ensures no single component failure can disrupt the entire network.
- **Challenge**
    - Redundant Layer 2 (switch) topologies can introduce network loops if not properly managed.

---

### Problems with Redundant Layer 2 Designs

- **Potential Issues**
    - **Broadcast Storms:** Endless flooding of broadcasts without loop prevention.
    - **Multiple Frame Transmission:** Multiple copies of unicast frames may be delivered, causing errors.
    - **MAC Database Instability:** Switches receive the same frame on different ports, causing MAC table instability.
- **Reason**
    - Layer 2 protocols (like Ethernet) lack mechanisms to limit looping frames.
    - Layer 3 protocols use TTL to limit retransmissions; Layer 2 does not.

---

### Spanning Tree Protocol (STP) and its Role

- **Function**
    - Prevents loops by determining the optimal path to the root switch.
    - Blocks paths that could cause loops; allows forwarding on optimal paths.
    - Automatically reconverges (recalculates paths) if failures occur.
- **Security Risk**
    - STP recalculations can be exploited by attackers to change topology and intercept traffic (e.g., Man-in-the-Middle attacks).

---

### STP Manipulation and Security Features

#### 1. PortFast

- **Purpose**
    - Reduces delay when end devices connect by immediately transitioning ports to the forwarding state, bypassing listening and learning.
- **Use Case**
    - Recommended for access ports connected to end devices (not switches).
    - Can be enabled on trunk ports, typically for Layer 3 devices.
- **Risk**
    - If enabled on a port connected to another switch, can cause loops.

#### 2. BPDU Guard

- **Purpose**
    - Protects against unauthorized switches or attackers sending BPDUs on access ports.
    - Works with PortFast; disables the port if a BPDU is received.
- **Benefit**
    - Prevents accidental or malicious introduction of switches/loops on access ports.

#### 3. Root Guard

- **Purpose**
    - Enforces which switch can be the root bridge by preventing certain ports from participating in root bridge elections.
    - If a port receives a superior BPDU, it transitions to "root-inconsistent" (listening) state, blocking traffic.
- **Deployment**
    - Best on ports connected to switches that should not be root bridge or on access switch interfaces.

---

### Attack Example: Man-in-the-Middle via STP Manipulation

- **How It Works**
    - Attacker sends BPDUs with a better bridge ID to become the root bridge.
    - STP recalculates topology, sending traffic through the attacker (now the root bridge).
    - Enables man-in-the-middle interception of network traffic.

---

### Configuration Examples

#### Interface Mode (Recommended for Explicit Control)

- Enable features on specific interfaces:
    - `spanning-tree portfast`
    - `spanning-tree bpduguard enable`
    - `spanning-tree guard root`

#### Global Mode (Applies to All Nontrunking Ports)

- Enable features globally:
    - `spanning-tree portfast default`
    - `spanning-tree portfast bpduguard default`

---

### Key Takeaways

- **Redundant designs increase availability but must be paired with loop-avoidance protocols like STP.**
- **STP can be manipulated; use PortFast, BPDU guard, and root guard to secure the topology.**
- **Configure security features at the interface level for precise protection.**
- **Proper deployment of these features helps maintain both network availability and security.**